// Fonction pour générer des valeurs aléatoires dans les plages spécifiées
function getRandom(min, max, precision = 1) {
    return (Math.random() * (max - min) + min).toFixed(precision);
}

// Fonction pour mettre à jour les mesures
function updateMeasurements() {
    document.getElementById("temp").textContent = getRandom(-20, 50, 1);
    document.getElementById("hum").textContent = getRandom(0, 100, 1);
    document.getElementById("press").textContent = getRandom(960, 1100, 0);
    document.getElementById("lux").textContent = getRandom(1, 65535, 0);
}

// Mise à jour toutes les 5 secondes
setInterval(updateMeasurements, 5000);

// Mise à jour initiale au chargement
window.onload = updateMeasurements;